/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.rsf;

import com.ibm.hwmca.base.rsf.BaseRemoteSupportFacility;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfDataTransfer;
import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.base.rsf.handlers.RetainUtils;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.requests.FormattedRequestData;
import com.ibm.hwmca.base.rsf.util.RsfHexadecimal;
import com.ibm.hwmca.base.rsf.util.TcpConnection;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.rsf.RsfRequestBody;
import com.ibm.hwmca.fw.rsf.RsfResultDetails;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.rsf.EssStorageProblemAttributes;
import com.ibm.hwmca.p.rsf.EssStorageProblemRequestBody;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;

public class EssStorageHandler
implements BaseRsfHandlersErrorIds,
BaseRsfDataTransfer,
EssStorageProblemAttributes {
    private static String TRACE_MASKF = "XRSFMM F";
    private static String TRACE_MASKT = "XRSFMM T";
    private static String TRACE_MASKD = "XRSFMM D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "EssStorageHandler");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    private static byte[] nulls = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static String nullBytes = new String(nulls);
    private static char nullByte = nullBytes.charAt(0);
    private static String blanks = "                                                               ";
    private long lastFileLength = 0L;
    private static File tempPath;
    private String tempFileName = null;
    private File tempFile = null;
    private String remotePath;
    private static final byte READ_COMFILE = 19;
    private static final byte READ_DATA2 = 21;
    private static final byte READ_DATA3 = 22;
    private static final byte READ_DATA4 = 23;
    private static final byte SEND_FILE = 0;
    private static final byte WRITE_DATA = 18;
    private static final byte WRITE_DATA_ERR = 20;
    private int response = 99;
    Socket connection;
    private static int MAX_MSG_LENGTH;
    private static String userPwd;
    private static String EBCDIC;
    private static int neg;
    private int papId = 3;
    private static int defaultTimeout;
    private boolean canceled = false;
    BufferedInputStream bin;
    BufferedOutputStream bout;
    XFrameRsfRequestBody rsfRequestBody;
    private BaseRsfRequestImpl request;
    private BaseRsfResultDetails resultDetails = new BaseRsfResultDetails();

    public void requestCancelling() {
        this.setCanceled(true);
    }

    public BaseRsfResultDetails getResult() {
        return this.resultDetails;
    }

    public int transmit(TcpConnection tcpPath, RsfRequestBody requestBody, BaseRsfRequestImpl request) throws IOException {
        if (BaseRemoteSupportFacility.testRQ) {
            Trace.trace(TRACE_MASKF, "EssStorageHandler.transmit(): about to execute test wait");
            try {
                Thread.sleep(BaseRemoteSupportFacility.testWait);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Trace.trace(TRACE_MASKF, "EssStorageHandler.transmit(): finished executing test wait");
            if (this.isCanceled()) {
                Trace.trace(TRACE_MASKF, "<- EssStorageHandler.transmit(): Canceled during test wait");
                return 99;
            }
        }
        Trace.trace(TRACE_MASKT, "-> EssStorageHandler::transmit()");
        try {
            this.connection = tcpPath.getSocket();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "EssStorageHandler: unable to get socket from tcp connection");
            this.resultDetails.setReasonCode(4);
            throw e;
        }
        try {
            this.rsfRequestBody = (XFrameRsfRequestBody)requestBody;
        }
        catch (ClassCastException e) {
            this.logInternalError("EssStorageHandler.transmit(): wrong class type for request. Found " + this.rsfRequestBody.getClass().getName() + ".", e);
            this.resultDetails.setErrLogMsg("Invalid request class type.  Found " + this.rsfRequestBody.getClass().getName());
            Trace.trace(TRACE_MASKT, "<- EssStorageHandler::transmit()");
            return 90;
        }
        if (!(this.rsfRequestBody instanceof FormattedRequestData)) {
            this.logInternalError("EssStorageHandler.transmit(): data class '" + this.rsfRequestBody.getClass().getName() + "' does not implement ForamttedRequestData.", null);
            this.resultDetails.setErrLogMsg("Invalid request class '" + this.rsfRequestBody.getClass().getName() + "' does not implement FormattedRequestData.");
            Trace.trace(TRACE_MASKT, "<- EssStorageHandler::transmit()");
            return 90;
        }
        this.request = request;
        try {
            this.bin = new BufferedInputStream(this.connection.getInputStream());
            this.bout = new BufferedOutputStream(this.connection.getOutputStream());
        }
        catch (IOException e) {
            this.resultDetails.setReasonCode(4);
            Trace.trace(TRACE_MASKF, "Exception constructing IO streams " + e.getMessage());
            Trace.trace(TRACE_MASKT, "<- EssStorageHandler::transmit ");
            throw e;
        }
        int rc = this.doProcessing();
        Trace.trace(TRACE_MASKT, "<- EssStorageHandler::transmit");
        return rc;
    }

    private int doProcessing() throws IOException {
        byte[] loginRecord;
        boolean rc = false;
        Trace.trace(TRACE_MASKT, "-> EssStorageHandler::doProcessing");
        try {
            loginRecord = RetainUtils.getLoginInfo(this.papId, this.rsfRequestBody, null);
        }
        catch (Exception e) {
            this.logInternalError("EssStorageHandler error getting login info", e);
            this.resultDetails.setErrLogMsg("Error getting login record for " + this.rsfRequestBody.getClass().getName());
            return 999;
        }
        if (this.isCanceled()) {
            Trace.trace(TRACE_MASKT, "<- EssStorageHandler::doTransfer already canceled");
            return 99;
        }
        int loginResult = RetainUtils.loginToRetain(this.request, this.connection, this.bin, this.bout, loginRecord, this.resultDetails, false);
        if (loginResult != 0) {
            Trace.trace(TRACE_MASKF, "EssStorageHandler.doProcessing(): reporting an unregistered or unrecognized machine");
            try {
                this.connection.close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "EssStorageHandler::doProcessing() Error closing connection");
            }
            Trace.trace(TRACE_MASKT, "<- EssStorageHandler::doProcessing()");
            return loginResult;
        }
        boolean OK = true;
        try {
            while (OK && !this.isCanceled()) {
                OK = this.receiveCommand();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            try {
                this.connection.close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "EssStorageHandler::doProcessing() Error closing connection");
            }
            Trace.trace(TRACE_MASKT, "<- EssStorageHandler::doProcessing() OK");
            return this.response;
        }
        catch (IOException i) {
            Trace.trace(TRACE_MASKF, "EssStorageHandler::doProcessing() IOException");
            Trace.trace(TRACE_MASKF, i);
            try {
                this.connection.close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "EssStorageHandler.doProcessing Error closing connection");
            }
            throw i;
        }
    }

    private boolean receiveCommand() throws IOException {
        Trace.trace(TRACE_MASKD, "-> EssStorageHandler::receiveCommand()");
        int timeout = defaultTimeout;
        if (!this.isCanceled()) {
            byte[] data;
            try {
                data = RetainUtils.receive(this.connection, this.bin, timeout);
                if (data == null || data.length < 2) {
                    this.logErrorAndContinue("EssStorageHandler.receiveCommand: no data in RETAIN command", null, (short)28530);
                    this.resultDetails.setReasonCode(3);
                    this.response = 0;
                    Trace.trace(TRACE_MASKD, "<- EssStorageHandler::receiveCommand() false");
                    return false;
                }
            }
            catch (IOException i) {
                Trace.trace(TRACE_MASKF, "EssStorageHandler.receiveCommand: Error receiving PAP request");
                Trace.trace(TRACE_MASKF, i);
                Trace.trace(TRACE_MASKD, "<- EssStorageHandler::receiveCommand() throw I/O Exception");
                this.response = 99;
                throw i;
            }
            boolean retval = this.processCommand(data);
            Trace.trace(TRACE_MASKT, "<- EssStorageHandler::receiveCommand()" + retval);
            return retval;
        }
        Trace.trace(TRACE_MASKD, "<- EssStorageHandler::receiveCommand() false");
        return false;
    }

    private boolean processCommand(byte[] data) throws IOException {
        Trace.trace(TRACE_MASKT, "-> EssStorageHandler::processCommand()");
        int printLength = Math.min(data.length, 32);
        Trace.trace(TRACE_MASKD, "EssStorageHandler receive data:\n" + RsfHexadecimal.buildHexadecimalString(data, 0, printLength) + "\n" + new String(data, 0, printLength, EBCDIC));
        byte command = data[0];
        boolean retval = false;
        if (command == 19) {
            return this.sendComfile();
        }
        if (command == 21) {
            return this.sendData(2);
        }
        if (command == 22) {
            return this.sendData(3);
        }
        if (command == 23) {
            return this.sendData(4);
        }
        if (command == 0) {
            if (data[5] != 18) {
                this.logRetainError("Invalid command from RETAIN PAP:" + RsfHexadecimal.buildHexadecimalString(data, 0, 6));
                Trace.trace(TRACE_MASKT, "<- EssStorageHandler::processCommand() invalid command");
                return false;
            }
            this.readFile(data);
            return false;
        }
        if (command == 18) {
            this.buildReply(data);
            return false;
        }
        if (command == 20) {
            this.buildReply(data);
            return false;
        }
        this.logRetainError("Invalid command from RETAIN PAP:" + command);
        Trace.trace(TRACE_MASKT, "<- EssStorageHandler::processCommand() invalid command");
        return false;
    }

    private boolean sendData(int dataNum) throws IOException {
        String data;
        try {
            data = ((EssStorageProblemRequestBody)this.rsfRequestBody).buildDataLineComfile(dataNum);
        }
        catch (ClassCastException e) {
            this.logInternalError("EssStorageHandler.transmit(): wrong class type for additional data request. Found " + this.rsfRequestBody.getClass().getName() + ".", e);
            this.resultDetails.setErrLogMsg("Invalid request class type for additional data request.  Found " + this.rsfRequestBody.getClass().getName());
            this.response = 90;
            return false;
        }
        RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(data.length()), 2, false);
        RetainUtils.send(this.bout, data, true);
        Trace.trace(TRACE_MASKD, "EssStorageHandler.sendData done");
        return true;
    }

    private boolean sendComfile() throws IOException {
        if (!this.isCanceled()) {
            String data = ((FormattedRequestData)((Object)this.rsfRequestBody)).buildData();
            RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(data.length()), 2, false);
            RetainUtils.send(this.bout, data, true);
            Trace.trace(TRACE_MASKD, "EssStorageHandler.sendComfile done");
        }
        return true;
    }

    private void buildReply(byte[] data) {
        Trace.trace(TRACE_MASKT, "-> EssStorageHandler::buildReply()");
        this.response = 0;
        RsfResultDetails rsfDetails = this.resultDetails.getRsfResultDetails();
        String pmh = null;
        try {
            if (data.length >= 31) {
                pmh = new String(data, 27, 5, EBCDIC);
            } else {
                Trace.trace(TRACE_MASKF, "EssStorageHandler: buildReply length < 31 = " + data.length);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pmh != null && !pmh.equals("     ")) {
            Trace.trace(TRACE_MASKD, "EssStorageHandler pmh=" + pmh);
            rsfDetails.putAttribute("pmh", pmh);
        }
        Trace.trace(TRACE_MASKT, "<- EssStorageHandler::buildReply()");
    }

    private boolean readFile(byte[] data) throws IOException {
        Trace.trace(TRACE_MASKT, "-> EssStorageHandler::readFile()");
        byte nameLength = data[7];
        String filename = null;
        try {
            filename = new String(data, 10, 10 + nameLength, EBCDIC).trim();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (filename == null) {
            this.logRetainError("EssStorageHandler.readFile: no filename found in RETAIN command");
            return false;
        }
        Trace.trace(TRACE_MASKF, "EssStorageHandler::readFile filename='" + filename + "'");
        int blockSize = 4096;
        boolean fileReady = true;
        if (this.tempFileName == null) {
            try {
                this.tempFile = File.createTempFile("iqy", ".tmp", tempPath);
                this.tempFileName = this.tempFile.getAbsolutePath();
            }
            catch (IOException ioe) {
                this.logInternalErrorAndContinue("EssStorageHandler.readFile: Cannot create temp file", ioe);
                fileReady = false;
            }
        } else {
            try {
                this.tempFile.createNewFile();
            }
            catch (Exception e) {
                this.logInternalErrorAndContinue("EssStorageHandler.readFile: Error creating new file with temp file name=" + this.tempFile.getAbsolutePath(), e);
                fileReady = false;
            }
        }
        String localFilename = this.tempFileName;
        if (fileReady) {
            if (this.request.isLocalRequest()) {
                Trace.trace(TRACE_MASKD, "EssStorageHandler.readFile: copying local file for send to RETAIN");
                try {
                    FileUtilities.copy(filename, this.tempFileName);
                }
                catch (Exception e) {
                    this.logInternalErrorAndContinue("EssStorageHandler.readFile: Unable to copy file locally: " + filename, e);
                    fileReady = false;
                }
            } else {
                Trace.trace(TRACE_MASKD, "EssStorageHandler.readFile: transfering remote file for send to RETAIN");
                fileReady = this.request.getFile(this.tempFileName, filename, true);
            }
        }
        File localFile = new File(this.tempFileName);
        Trace.trace(TRACE_MASKD, "EssStorageHandler.readFile: name of file to be transferred:'" + localFilename + "'");
        File file = new File(localFilename);
        if (fileReady) {
            byte[] buffer = new byte[blockSize];
            try {
                Trace.trace(TRACE_MASKD, "EssStorageHandler.readFile: About to get file length for '" + localFilename + "'");
                this.lastFileLength = file.length();
                Trace.trace(TRACE_MASKD, "EssStorageHandler.readFile: Length of file:" + this.lastFileLength);
                FileInputStream fis = new FileInputStream(file);
                Trace.trace(TRACE_MASKD, "EssStorageHandler.readFile: Created input stream for file");
                String header = nullBytes + new String(EssStorageHandler.calc4ByteLength((int)this.lastFileLength), EBCDIC) + blanks.substring(0, 12);
                int bytesRead = blockSize;
                long remainder = this.lastFileLength;
                while (remainder > 0L && bytesRead > 0 && !this.isCanceled() && fileReady) {
                    try {
                        long bufferLength = Math.min(remainder, (long)buffer.length);
                        bytesRead = fis.read(buffer, 0, (int)bufferLength);
                    }
                    catch (IOException e) {
                        this.logErrorAndContinue("EssStorageHandler.readFile: Error reading file:" + filename, e, (short)28453);
                        fileReady = false;
                    }
                    if (bytesRead < blockSize && (long)bytesRead < remainder) {
                        Trace.trace(TRACE_MASKF, "EssStorageHandler.readFile: File shrunk? Bytes read from file=" + bytesRead + " blockSize=" + blockSize + " remainder=" + remainder);
                        remainder = bytesRead;
                    }
                    if (!fileReady || bytesRead <= 0) continue;
                    Trace.trace(TRACE_MASKD, "EssStorageHandler.readFile: File header=" + header + ".  Sending " + bytesRead + " bytes from file.");
                    RetainUtils.sendBytes(this.bout, RetainUtils.calcLength(header.length() + bytesRead), 2, false);
                    RetainUtils.send(this.bout, header, false);
                    RetainUtils.sendBytes(this.bout, buffer, bytesRead, true);
                    remainder -= (long)bytesRead;
                }
                if (this.isCanceled()) {
                    file.delete();
                    Trace.trace(TRACE_MASKT, "<- EssStorageHandler::readFile() canceled");
                    return false;
                }
            }
            catch (FileNotFoundException e) {
                this.logErrorAndContinue("EssStorageHandler.readFile: Can't find file:" + filename, e, (short)28453);
                fileReady = false;
                this.lastFileLength = 0L;
            }
            catch (IOException e) {
                this.logErrorAndContinue("EssStorageHandler.readFile: Error sending file", e, (short)28592);
                this.lastFileLength = 0L;
                file.delete();
                Trace.trace(TRACE_MASKT, "<- EssStorageHandler::readFile() throwing I/O Exception");
                throw e;
            }
        }
        file.delete();
        Trace.trace(TRACE_MASKT, "<- EssStorageHandler::readFile() true");
        this.response = 0;
        return true;
    }

    private int getLength(byte[] data, int index, int numBytes) throws IllegalArgumentException {
        if (numBytes > 4) {
            throw new IllegalArgumentException("Can't get length for more than four bytes");
        }
        Trace.trace(TRACE_MASKD, "EssStorageHandler.getLength (hex bytes)=" + RsfHexadecimal.buildHexadecimalString(data, index, numBytes));
        int andByte = 127;
        int length = 0;
        int i = 0;
        while (i < numBytes) {
            length *= 256;
            length = data[index + i] < 0 ? (length += (data[index + i] & andByte) + 128) : (length += data[index + i]);
            ++i;
        }
        return length;
    }

    synchronized void setCanceled(boolean cancel) {
        this.canceled = cancel;
    }

    synchronized boolean isCanceled() {
        return this.canceled;
    }

    private static byte assignByte(int i) {
        if (i <= 127) {
            return (byte)i;
        }
        return (byte)(i | neg);
    }

    public static byte[] calc4ByteLength(int length) {
        Trace.trace(TRACE_MASKD, "EssStorageHandler length=" + length);
        int remainder = length;
        byte[] byteLength = new byte[4];
        byteLength[3] = (byte)(remainder % 256);
        byteLength[2] = (byte)((remainder >>>= 8) % 256);
        byteLength[1] = (byte)((remainder >>>= 8) % 256);
        byteLength[0] = (byte)(remainder >>>= 8);
        Trace.trace(TRACE_MASKD, "RetainUtils: Send length=" + RsfHexadecimal.buildHexadecimalString(byteLength));
        return byteLength;
    }

    private void logRetainError(String errorMsg) {
        this.resultDetails.setReasonCode(3);
        this.response = 999;
        Trace.trace(TRACE_MASKF, errorMsg);
        FrameworkLog errLog = new FrameworkLog(logInfo, 28530);
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private void logErrorAndExit(String errorMsg, Throwable t, short errorId, int resultError) {
        this.resultDetails.setReasonCode(resultError);
        this.response = 999;
        Trace.trace(TRACE_MASKF, errorMsg);
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, errorId, t) : new FrameworkLog(logInfo, errorId);
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    private void logInternalError(String errorMsg, Throwable t) {
        this.logErrorAndExit(errorMsg, t, (short)28671, 7);
    }

    private void logInternalErrorAndContinue(String errorMsg, Throwable t) {
        this.logErrorAndContinue(errorMsg, t, (short)28671);
    }

    private void logErrorAndContinue(String errorMsg, Throwable t, short errorId) {
        Trace.trace(TRACE_MASKF, errorMsg);
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, errorId, t) : new FrameworkLog(logInfo, errorId);
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    static {
        MAX_MSG_LENGTH = 60;
        userPwd = "URSF/PURUS    URSFTST 0924-5575        ";
        EBCDIC = "Cp500";
        neg = -256;
        defaultTimeout = 4500000;
        try {
            tempPath = new File(BaseFileControl.getFilePath("tmp"));
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "EssStorageHandler: static block - Unable to get temp file path");
            new FrameworkLog(logInfo, 28451, e).log(infoLog);
        }
    }
}

